/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.micrometer;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaType;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtaClientMicroMeter
implements MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(RtaClientMicroMeter.class);
    private Map<RtaType, Timer> timer = Maps.newHashMap();
    private Map<RtaType, Counter> success = Maps.newHashMap();
    private Map<RtaType, Counter> fail = Maps.newHashMap();
    private Map<RtaType, Counter> connectException = Maps.newHashMap();
    private Map<RtaType, Counter> readException = Maps.newHashMap();
    private Map<RtaType, Counter> otherException = Maps.newHashMap();
    private Map<RtaType, Counter> withCaching = Maps.newHashMap();
    private final Iterable<RtaClient> clients;

    public RtaClientMicroMeter(Iterable<RtaClient> clients) {
        this.clients = clients;
    }

    public void bindTo(MeterRegistry registry) {
        for (RtaClient client : this.clients) {
            RtaType rtaType = client.getRtaType();
            Counter successCounter = Counter.builder((String)"rta.success").tag("name", rtaType.name()).register(registry);
            Counter failCounter = Counter.builder((String)"rta.fail").tag("name", rtaType.name()).register(registry);
            Counter requestExceptionCounter = Counter.builder((String)"rta.connect.ex").tag("name", rtaType.name()).register(registry);
            Counter socketTimeoutExceptionCounter = Counter.builder((String)"rta.read.ex").tag("name", rtaType.name()).register(registry);
            Counter otherExceptionCounter = Counter.builder((String)"rta.other.ex").tag("name", rtaType.name()).register(registry);
            Counter withCachingCounter = Counter.builder((String)"rta.other.with.caching").tag("name", rtaType.name()).register(registry);
            Timer.Builder timerBuilder = Timer.builder((String)"rta.requests").tag("name", rtaType.name());
            if (client.getProperties().isPublishPercentiles()) {
                timerBuilder.publishPercentiles(new double[]{0.5, 0.75, 0.9, 0.95, 0.99});
            }
            Timer theTimer = timerBuilder.register(registry);
            this.success.put(rtaType, successCounter);
            this.fail.put(rtaType, failCounter);
            this.timer.put(rtaType, theTimer);
            this.connectException.put(rtaType, requestExceptionCounter);
            this.readException.put(rtaType, socketTimeoutExceptionCounter);
            this.otherException.put(rtaType, otherExceptionCounter);
            this.withCaching.put(rtaType, withCachingCounter);
        }
    }

    void incrementSuccess(RtaType rtaType) {
        Counter counter = this.success.get((Object)rtaType);
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }

    void incrementFail(RtaType rtaType) {
        Counter counter = this.fail.get((Object)rtaType);
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }

    void incrementConnectException(RtaType rtaType) {
        Counter counter = this.connectException.get((Object)rtaType);
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }

    void incrementReadException(RtaType rtaType) {
        Counter counter = this.readException.get((Object)rtaType);
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }

    void incrementOtherException(RtaType rtaType) {
        Counter counter = this.otherException.get((Object)rtaType);
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }

    public void incrementWithCaching(RtaType rtaType) {
        Counter counter = this.withCaching.get((Object)rtaType);
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }

    void record(RtaType rtaType, long startNanoTime) {
        Timer timer = this.timer.get((Object)rtaType);
        if (Objects.nonNull(timer)) {
            timer.record(System.nanoTime() - startNanoTime, TimeUnit.NANOSECONDS);
        }
    }
}

