/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.taobao_activity;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaClientProperties;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.taobao_activity.TaobaoActivityRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.SafeMapHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.request.TbkRtaConsumerMatchRequest;
import com.taobao.api.response.TbkRtaConsumerMatchResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaobaoActivityRtaClient
implements RtaClient {
    private static final Logger log = LoggerFactory.getLogger(TaobaoActivityRtaClient.class);
    private final TaobaoActivityRtaProperties properties;
    private final ConcurrentHashMap<String, TaobaoClient> clients = new ConcurrentHashMap();

    public TaobaoActivityRtaClient(TaobaoActivityRtaProperties properties) {
        this.properties = properties;
        TaobaoLogger.setNeedEnableLogger((boolean)properties.isNeedEnableLogger());
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.TaobaoActivity;
    }

    @Override
    public RtaClientProperties getProperties() {
        return this.properties;
    }

    private TaobaoClient getClient(String appKey, String appSecret) {
        return (TaobaoClient)SafeMapHelper.get(this.clients, (Object)appKey, () -> {
            String url = this.properties.getUrl();
            int connectTimeout = this.properties.getConnectTimeout();
            int socketTimeout = this.properties.getSocketTimeout();
            return new DefaultTaobaoClient(url, appKey, appSecret, "json", connectTimeout, socketTimeout);
        });
    }

    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        String param = request.getParam();
        Object[] arr = StringUtils.splitPreserveAllTokens((String)param, (String)"|");
        if (ArrayUtils.isEmpty((Object[])arr) || arr.length < 2) {
            throw new RtaRequestException("param");
        }
        long adzoneId = NumberUtils.toLong((String)arr[0]);
        Object offerId = arr[1];
        TbkRtaConsumerMatchRequest req = new TbkRtaConsumerMatchRequest();
        req.setAdzoneId(Long.valueOf(adzoneId));
        TbkRtaConsumerMatchRequest.OfferList offer = new TbkRtaConsumerMatchRequest.OfferList();
        offer.setOfferId((String)offerId);
        req.setOfferList((List)Lists.newArrayList((Object[])new TbkRtaConsumerMatchRequest.OfferList[]{offer}));
        String oaidMd5 = request.getOaid_md5();
        if (StringUtils.isBlank((String)req.getDeviceValue()) && StringUtils.isNotBlank((String)oaidMd5)) {
            req.setDeviceValue(oaidMd5);
            req.setDeviceType("OAID");
        }
        String imeiMd5 = request.getImei_md5();
        if (StringUtils.isBlank((String)req.getDeviceValue()) && StringUtils.isNotBlank((String)imeiMd5)) {
            req.setDeviceValue(imeiMd5);
            req.setDeviceType("IMEI");
        }
        String idfaMd5 = request.getIdfa_md5();
        if (StringUtils.isBlank((String)req.getDeviceValue()) && StringUtils.isNotBlank((String)idfaMd5)) {
            req.setDeviceValue(idfaMd5);
            req.setDeviceType("IDFA");
        }
        try {
            Object appKey = this.properties.getAppKey();
            Object appSecret = this.properties.getAppSecret();
            if (arr.length > 2) {
                appKey = arr[2];
            }
            if (arr.length > 3) {
                appSecret = arr[3];
            }
            TaobaoClient client = this.getClient((String)appKey, (String)appSecret);
            TbkRtaConsumerMatchResponse rsp = (TbkRtaConsumerMatchResponse)client.execute((TaobaoRequest)req);
            TbkRtaConsumerMatchResponse.Data data = rsp.getData();
            if (log.isDebugEnabled()) {
                log.debug("response: {}", (Object)JsonHelper.convert((Object)rsp));
            }
            if (Objects.isNull(data)) {
                return false;
            }
            List resultList = data.getResultList();
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                return false;
            }
            Optional<TbkRtaConsumerMatchResponse.Resultlist> first = resultList.stream().filter(resultlist -> "1".equals(resultlist.getStatus())).findFirst();
            if (!first.isPresent()) {
                return false;
            }
            TbkRtaConsumerMatchResponse.Resultlist result = first.get();
            String clickUrl = result.getClickUrl();
            if (Objects.nonNull(feedback)) {
                HashMap map = Maps.newHashMap();
                map.put("clickUrl", clickUrl);
                feedback.accept(map);
            }
            return true;
        }
        catch (Exception e) {
            throw new RtaRequestException(e);
        }
    }
}

