package com.bxm.pangu.rta.common.baichuan;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author allen
 * @date 2021-12-20
 * @since 1.0
 */
@Data
public class BaichuanResponse implements Serializable {
    private static final long serialVersionUID = 3103059232987778619L;

    private int code = -1;
    private String message;
    private List<Data> data;

    public boolean isRequestOk() {
        return code == 200;
    }

    @EqualsAndHashCode(callSuper = true)
    @lombok.Data
    public static class Data extends BaichuanRequest.DeviceMsg{
        /**
         * 策略ID数组
         */
        public List<String> rtaIdList;
    }
}
