package com.bxm.pangu.rta.common.dyfx;

import lombok.Data;
import org.apache.http.HttpStatus;

import java.io.Serializable;

/**
 * @author jingyu.li
 * @date 2023-04-10
 */
@Data
public class DyfxRtaResponse implements Serializable {
    private Integer code;
    private Boolean success;
    private String message;
    private DyfxResponse data;

    @Data
    public class DyfxResponse {
        private Boolean potentialCustomer;
        private Boolean lostCustomer;
    }

    public Boolean isSuccess() {
        if (code == null || code != HttpStatus.SC_OK) {
            return false;
        }
        return true;
    }
}
