package com.bxm.pangu.rta.common.mango;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Optional;

/**
 * @author allen
 * @date 2021-12-23
 * @since 1.0
 */
public class MangoRtaClient extends AbstractHttpClientRtaClient {

    private final MangoRtaProperties properties;

    public MangoRtaClient(MangoRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();

        String appId = properties.getAppId();
        String t = TypeHelper.castToString(System.currentTimeMillis());
        String apiKey = properties.getApiKey();
        String token = DigestUtils.md5Hex(appId + apiKey + t).toLowerCase();

        params.add("appId", appId);
        params.add("timeStamp", t);
        params.add("apiToken", token);
        params.add("imeiMd5", Optional.ofNullable(request.getImei_md5()).orElse(StringUtils.EMPTY));
        params.add("imei", Optional.ofNullable(request.getImei()).orElse(StringUtils.EMPTY));
        params.add("oaidMd5", Optional.ofNullable(request.getOaid_md5()).orElse(StringUtils.EMPTY));
        params.add("oaid", Optional.ofNullable(request.getOaid()).orElse(StringUtils.EMPTY));
        params.add("idfaMd5", Optional.ofNullable(request.getIdfa_md5()).orElse(StringUtils.EMPTY));
        params.add("idfa", Optional.ofNullable(request.getIdfa()).orElse(StringUtils.EMPTY));
        params.add("type", request.getParam());
        params.add("os", request.getOs());

        String url = UriComponentsBuilder.fromUriString(properties.getUrl()).replaceQueryParams(params).build().toString();
        return new HttpGet(url);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return JsonHelper.convert(json, MangoResponse.class).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Mango;
    }
}
