package com.bxm.pangu.rta.common.myhayo;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.List;

/**
 * @author allen
 * @date 2021-10-12
 * @since 1.0
 */
@Slf4j
public class MyhayoRtaClient extends AbstractHttpClientRtaClient {

    private final MyhayoRtaProperties properties;

    public MyhayoRtaClient(MyhayoRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = properties.getUrl();
        String channel = properties.getChannel();

        // test: imeiMd5=20a4b4f3cb04d12c7ce9d07903d91291
        // test: idfa=CCD6E1CD-8C4B-40CB-8A62-4BBC7AFE07D6

        String finalUrl = UriComponentsBuilder.fromUriString(url)
                .replaceQueryParam("channel", channel)
                .replaceQueryParam("product", request.getParam())
                .replaceQueryParam("imeiMd5", request.getImei_md5())
                .replaceQueryParam("oaid", request.getOaid())
                .replaceQueryParam("idfaMd5", request.getIdfa_md5())
                .build()
                .toString();
        return new HttpGet(finalUrl);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return JsonHelper.convert(json, Response.class).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Myhayo;
    }

    @Data
    private static class Response {

        private String product;
        private String code;
        private List<String> data;

        boolean isTarget() {
            return StringUtils.equals("0", code);
        }
    }
}
