package com.bxm.pangu.rta.common.qihang.enums;

import com.bxm.adx.common.AdxConstants;
import lombok.Getter;

/**
 * @author zhangdong
 * @date 2022/10/13
 */
@Getter
public enum ImpTypeEnum {
    /**
     * 信息流
     */
    NATIVE(1, "信息流"),
    KAI_PING(2, "开屏"),
    BANNER(3, "banner"),
    CHA_PING(4, "插屏"),
    INSPIRE_VIDEO(9, "激励视频"),

    ;


    private Integer code;

    private String desc;

    ImpTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer toRequestImpTypeByType(Integer type) {
        if (type == null) {
            return NATIVE.getCode();
        }
        if (AdxConstants.Type.INSPIRE_VIDEO.getType().equals(type)) {
            return INSPIRE_VIDEO.getCode();
        }
        if (AdxConstants.Type.VIDEO.getType().equals(type)) {
            return INSPIRE_VIDEO.getCode();
        }
        if (AdxConstants.Type.IMAGE.getType().equals(type)) {
            return KAI_PING.getCode();
        }
        return NATIVE.getCode();
    }

    public static Integer toRequestImpTypeByImpType(Integer type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case 3:
                return BANNER.getCode();
            case 4:
                return CHA_PING.getCode();
            case 2:
                return KAI_PING.getCode();
            case 8:
                return INSPIRE_VIDEO.getCode();
            case 1:
                return NATIVE.getCode();
            default:
                return null;
        }
    }
}
