package com.bxm.pangu.rta.common.jdjr;

import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.*;
import com.bxm.warcar.utils.SafeMapHelper;
import com.jddglobal.open.client.JddClient;
import com.jddglobal.open.support.config.EsuSdkConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

/**
 * 京东金融rta
 * @author lijingyu
 * @date 2023-03-22
 * @since 1.0
 */
@Slf4j
public class JdjrRtaClient implements RtaClient {
    private static final String FID = "eWh1ODQ3c2oyMDR1NGo0anI4M2VyNQ";
    private static final String CHANNEL_CODE = "bianxianmao";
    private final AbstractRtaProperties properties;

    private final ConcurrentHashMap<String, JddClient> clients = new ConcurrentHashMap<>();

    public JdjrRtaClient(AbstractRtaProperties properties) {
        this.properties = properties;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Jd;
    }

    @Override
    public RtaClientProperties getProperties() {
        return properties;
    }

    private JddClient getClient(String fid) {
        return SafeMapHelper.get(clients, fid, (SafeMapHelper.InitializingValue<JddClient>) () -> EsuSdkConfig.getJddClient());
    }

    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        String idType = null;
        String idMd5Value = null;
        String idfaMd5 = request.getIdfa_md5();
        if (StringUtils.isNotBlank(idfaMd5)) {
            idType = "idfa";
            idMd5Value = idfaMd5;
        }
        String imeiMd5 = request.getImei_md5();
        if (StringUtils.isBlank(idMd5Value) && StringUtils.isNotBlank(imeiMd5)) {
            idType = "imei";
            idMd5Value = imeiMd5;
        }
        String oaidMd5 = request.getOaid_md5();
        if (StringUtils.isBlank(idMd5Value) && StringUtils.isNotBlank(oaidMd5)) {
            idType = "oaid";
            idMd5Value = oaidMd5;
        }
        if (StringUtils.isBlank(idMd5Value)) {
            throw new RtaRequestException("device number is empty");
        }

        try {
            MarketShowAdBatchRequest rtaRequest = new MarketShowAdBatchRequest();
            rtaRequest.setChannelCode(CHANNEL_CODE);
            rtaRequest.setFid(FID);
            ArrayList<Map<String, String>> list = new ArrayList<>();
            Map<String, String> oaid = new HashMap<>();
            oaid.put("idType", idType);
            oaid.put("idMd5Value", idMd5Value);
            list.add(oaid);
            rtaRequest.setDeviceIds(list);

            JddClient jddClient = getClient(FID);
            MarketShowAdBatchResponse response = jddClient.execute(rtaRequest);
            if (log.isDebugEnabled()) {
                log.debug("京东金融 response : {}",JSONObject.toJSONString(response));
            }

            Map<String, Map<String, Object>> data = response.getData();
            if (MapUtils.isEmpty(data)) {
                return false;
            }
            Map<String, Object> deviceResult = data.get(idMd5Value);
            if (MapUtils.isEmpty(deviceResult) || "n".equals(deviceResult.get("show"))) {
                return false;
            }

            return true;
        } catch (Exception e) {
            throw new RtaRequestException(e);
        }
    }
}
