package com.bxm.pangu.rta.common.qczj;

import com.bxm.pangu.rta.common.*;
import com.bxm.warcar.utils.JsonHelper;
import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.List;
import java.util.Objects;

/**
 * @author huxiao
 * @date 2023/9/6
 * @since 1.0.0
 */
public class QczjRtaClient extends AbstractHttpClientRtaClient {

    public QczjRtaClient(AbstractRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String channel = request.getParam();
        if (StringUtils.isBlank(channel)) {
            throw new RtaRequestException("channel");
        }
        String id = null, idType = null;
        if (StringUtils.isNotBlank(request.getOaid())) {
            id = request.getOaid();
            idType = "OAID";
        } else if (StringUtils.isNotBlank(request.getOaid_md5())) {
            id = request.getOaid_md5();
            idType = "OAID_MD5";
        } else if (StringUtils.isNotBlank(request.getIdfa())) {
            id = request.getIdfa();
            idType = "IDFA";
        } else if (StringUtils.isNotBlank(request.getIdfa_md5())) {
            id = request.getIdfa_md5();
            idType = "IDFA_MD5";
        } else if (StringUtils.isNotBlank(request.getImei())) {
            id = request.getImei();
            idType = "IMEI";
        } else if (StringUtils.isNotBlank(request.getImei_md5())) {
            id = request.getImei_md5();
            idType = "IMEI_MD5";
        } else if (StringUtils.isNotBlank(request.getAndroidid())) {
            id = request.getAndroidid();
            idType = "ANDROID_ID";
        } else if (StringUtils.isNotBlank(request.getAndroidid_md5())) {
            id = request.getAndroidid_md5();
            idType = "ANDROID_ID_MD5";
        } else {
            return null;
        }
        String url = UriComponentsBuilder.fromUriString(getProperties().getUrl())
                .queryParam("id", id)
                .queryParam("idType", idType)
                .queryParam("channel", channel)
                .build().toString();
        return new HttpGet(url);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return JsonHelper.convert(json, Res.class).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Qczj;
    }

    @Data
    public static class Res {
        private int returncode = -1;
        private String message;
        private Result result;

        public boolean isTarget() {
            return returncode == 0 && Objects.nonNull(result) && result.isAllowed();
        }
    }

    @Data
    public static class Result {
        private boolean allowed;
        private List<String> materialCodes;
    }
}
