package com.bxm.pangu.rta.common.qihang;

import com.bxm.pangu.rta.common.*;
import com.bxm.pangu.rta.common.qihang.proto.SurgeBidding;
import com.bxm.pangu.rta.common.qihang.request.BidRequest;
import com.bxm.warcar.utils.JsonHelper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.jsoup.helper.StringUtil;

/**
  *
  * @author jingyu.li
  * @date 2024-03-11
  */
@Slf4j
public class QiHangRtaClient extends AbstractHttpClientRtaClient {


    public QiHangRtaClient(AbstractRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        if (StringUtil.isBlank(request.getExt())) {
            return null;
        }
        BidRequest bidreq = JsonHelper.convert(request.getExt(), BidRequest.class);
        log.info("qiHangRtaBidRequest: {}",JsonHelper.convert(bidreq));
        SurgeBidding.BidRequest bidRequest = QiHangRequestBuilder.buildRequest(bidreq);
        try {
            log.info("qiHangRtaRequest:{}", JsonFormat.printer().print(bidRequest));
        } catch (InvalidProtocolBufferException e) {
        }
        HttpPost post = new HttpPost(getProperties().getUrl());
        post.setEntity(new ByteArrayEntity(bidRequest.toByteArray()));
        post.addHeader(HttpHeaders.CONTENT_TYPE, "application/x-protobuf;charset=UTF-8");
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return false;
    }

    @Override
    protected boolean isTarget(RtaRequest request, byte[] bytes) {
        try {
            SurgeBidding.BidResponse qiHangResponse = SurgeBidding.BidResponse.parseFrom(bytes);
            log.info("qiHangRtaResponse:{}",JsonFormat.printer().print(qiHangResponse));
            if (!qiHangResponse.getSeatBidList().isEmpty()) {
                return true;
            }
            return false;
        } catch (InvalidProtocolBufferException e) {
            log.error("qiHang buildResponse error:", e);
            return false;
        }
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.QiHangRtb;
    }

    @Override
    public ProtocolFormat getProtocolFormat() {
        return ProtocolFormat.Protobuf;
    }
}
