package com.bxm.pangu.rta.common.baidu_silent;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * @author allen
 * @date 2022-03-10
 * @since 1.0
 */
@Slf4j
public class BaiduSilentRtaClient extends AbstractHttpClientRtaClient {

    private final BaiduSilentRtaProperties properties;

    public BaiduSilentRtaClient(BaiduSilentRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = properties.getUrl();

        String param = request.getParam();
        if (StringUtils.isBlank(param)) {
            throw new RtaRequestException("param");
        }
        String[] arr = StringUtils.split(param, "|");
        if (arr.length < 2) {
            throw new RtaRequestException("param must be {channel_name}|{secretKey}");
        }

        Map<String, String> dp = new TreeMap<>();
        String imeiMd5 = request.getImei_md5();
        if (StringUtils.isBlank(imeiMd5)) {
            throw new RtaRequestException("imeiMd5 is blank!");
        }
        dp.put("imeis", imeiMd5);
        dp.put("channel_name", arr[0]);
        dp.put("request_time", String.valueOf(System.currentTimeMillis()));

        StringBuilder s = new StringBuilder();
        dp.forEach((key, value) -> s.append(key).append("=").append(value));
        s.append(arr[1]);
        dp.put("sign", DigestUtils.md5Hex(s.toString()));

        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        dp.forEach(params::add);

        String finalUrl = UriComponentsBuilder.fromUriString(url).replaceQueryParams(params).build().toString();

        return new HttpGet(finalUrl);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        if (log.isDebugEnabled()) {
            log.debug("{}", json);
        }
        return JsonHelper.convert(json, Res.class).isTarget(request.getImei_md5());
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.BaiduSilent;
    }

    @Data
    static class Res {
        private String errno;
        private List<String> data;
        private String msg;

        public boolean isTarget(String imeiMd5) {
            return StringUtils.equals("0", errno)
                    && CollectionUtils.isNotEmpty(data)
                    && data.contains(imeiMd5);
        }
    }
}
