package com.bxm.pangu.rta.common.core;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.warcar.integration.eventbus.EventPark;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.ArrayUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * @author allen
 * @date 2022-04-13
 * @since 1.0
 */
@Slf4j
@Aspect
@Order(Ordered.HIGHEST_PRECEDENCE + 1)
public class EventAspect {

    private final EventPark eventPark;

    public EventAspect(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    @Pointcut("this(com.bxm.pangu.rta.common.RtaClient) && execution(boolean isTarget(..))")
    public void pointcut() {}

    @Around("pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof RtaClient)) {
            return point.proceed();
        }
        RtaClient client = (RtaClient) target;
        Object[] args = point.getArgs();

        if (ArrayUtils.isEmpty(args)) {
            return point.proceed();
        }
        Object arg = args[0];
        if (!(arg instanceof RtaRequest)) {
            return point.proceed();
        }
        RtaRequest request = (RtaRequest) arg;

        Object ret = point.proceed();
        eventPark.post(new RequestEvent(this, client, request, (boolean) ret));
        return ret;
    }
}
