package com.bxm.pangu.rta.common.dyfx;

import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.*;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.springframework.http.MediaType;

import java.util.HashMap;
import java.util.Locale;

/**
 * 粉象-抖音判断是否为潜客和流失客户
 *
 * @author jingyu.li
 * @date 2023-04-10
 */
public class DyfxRtaClient extends AbstractHttpClientRtaClient {

    private final DyfxRtaProperties properties;

    public DyfxRtaClient(DyfxRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        Integer deviceFingerprintType = null;
        String deviceFingerprintId = null;
        Boolean md5 = false;

        String idfa = request.getIdfa();
        String idfaMd5 = request.getIdfa_md5();
        if (StringUtils.isNotBlank(idfa) || StringUtils.isNotBlank(idfaMd5)) {
            deviceFingerprintType = 1;
            if (StringUtils.isNotBlank(idfa)) {
                deviceFingerprintId = idfa;
            } else {
                deviceFingerprintId = idfaMd5.toUpperCase();
                md5 = true;
            }
        }

        String imei = request.getImei();
        String imeiMd5 = request.getImei_md5();
        if (StringUtils.isBlank(deviceFingerprintId) && (StringUtils.isNotBlank(imei) || StringUtils.isNotBlank(imeiMd5))) {
            deviceFingerprintType = 2;
            if (StringUtils.isNotBlank(imei)) {
                deviceFingerprintId = imei;
            } else {
                deviceFingerprintId = imeiMd5.toUpperCase();
                md5 = true;
            }
        }

        String androidid = request.getAndroidid();
        String androididMd5 = request.getAndroidid_md5();
        if (StringUtils.isBlank(deviceFingerprintId) && (StringUtils.isNotBlank(androidid) || StringUtils.isNotBlank(androididMd5))) {
            deviceFingerprintType = 3;
            if (StringUtils.isNotBlank(androidid)) {
                deviceFingerprintId = androidid;
            } else {
                deviceFingerprintId = androididMd5.toUpperCase();
                md5 = true;
            }
        }

        String gaid = request.getGaid();
        String gaidMd5 = request.getGaid_md5();
        if (StringUtils.isBlank(deviceFingerprintId) && (StringUtils.isNotBlank(gaid) || StringUtils.isNotBlank(gaidMd5))) {
            deviceFingerprintType = 4;
            if (StringUtils.isNotBlank(gaid)) {
                deviceFingerprintId = gaid;
            } else {
                deviceFingerprintId = gaidMd5.toUpperCase();
                md5 = true;
            }
        }

        String oaid = request.getOaid();
        String oaidMd5 = request.getOaid_md5();
        if (StringUtils.isBlank(deviceFingerprintId) && (StringUtils.isNotBlank(oaid) || StringUtils.isNotBlank(oaidMd5))) {
            deviceFingerprintType = 5;
            if (StringUtils.isNotBlank(oaid)) {
                deviceFingerprintId = oaid;
            } else {
                deviceFingerprintId = oaidMd5.toUpperCase();
                md5 = true;
            }
        }

        if (StringUtils.isBlank(deviceFingerprintId)) {
            throw new RtaRequestException("device is not empty!");
        }


        HashMap<String, Object> dyfxRequestMap = Maps.newHashMap();
        dyfxRequestMap.put("deviceFingerprintId",deviceFingerprintId);
        dyfxRequestMap.put("deviceFingerprintType",deviceFingerprintType);
        dyfxRequestMap.put("md5",md5);

        HttpPost httpPost = new HttpPost(properties.getUrl());
        httpPost.addHeader("Content-Type", MediaType.APPLICATION_JSON_VALUE);
        httpPost.setEntity(new ByteArrayEntity(JsonHelper.convert2bytes(dyfxRequestMap)));

        return httpPost;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        DyfxRtaResponse response = JsonHelper.convert(json, DyfxRtaResponse.class);
        if (!response.isSuccess()) {
            return false;
        }
        if (response.getData() == null || !response.getData().getPotentialCustomer()) {
            return false;
        }
        return true;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.dyfx;
    }
}
