package com.bxm.pangu.rta.common.qihang.enums;

import lombok.Getter;

/**
 * @author zhangdong
 * @date 2022/10/13
 */
@Getter
public enum DeviceTypeEnum {
    /**
     * 未知
     */
    UNKNOWN(0, "未知"),
    PC(3, "pc"),
    PHONE(4, "手机"),
    TABLET(5, "平板"),
    CONNECTED_DEVICE(6, "联网设备"),
    TOP_BOX(7, "机顶盒"),

    ;


    private Integer code;

    private String desc;

    DeviceTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer toRequestDeviceType(Integer type) {
        if (type == null) {
            return UNKNOWN.code;
        }
        if (type == 1) {
            return PHONE.code;
        }
        if (type == 2) {
            return TABLET.code;
        }
        return UNKNOWN.code;
    }


}
