package com.bxm.pangu.rta.common.tencent;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.ProtocolFormat;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.google.protobuf.InvalidProtocolBufferException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

import java.util.Optional;

/**
 * @author allen
 * @date 2021-12-27
 * @since 1.0
 */
@Slf4j
public class TencentVideoRtaClient extends AbstractHttpClientRtaClient {

    private final TencentVideoRtaProperties properties;

    public TencentVideoRtaClient(TencentVideoRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        TencentVideoRtaProtos.RtaRequest.Builder builder = TencentVideoRtaProtos.RtaRequest.newBuilder();
        builder.setId(RandomStringUtils.randomAlphanumeric(8));
        builder.setChannel(Optional.ofNullable(request.getParam()).orElse(properties.getChannel()));
        if (StringUtils.isNotBlank(request.getImei_md5())) {
            builder.setImeiMd5Sum(request.getImei_md5());
        }
        if (StringUtils.isNotBlank(request.getOaid())) {
            builder.setOaid(request.getOaid());
        }

        HttpPost post = new HttpPost(properties.getUrl());
        post.addHeader("Content-Type", "application/x-protobuf;charset=UTF-8");
        post.setEntity(new ByteArrayEntity(builder.build().toByteArray()));

        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProtocolFormat getProtocolFormat() {
        return ProtocolFormat.Protobuf;
    }

    @Override
    protected boolean isTarget(RtaRequest request, byte[] bytes) {
        try {
            TencentVideoRtaProtos.RtaResponse response = TencentVideoRtaProtos.RtaResponse.parseFrom(bytes);
            return response.getCode() == 0;
        } catch (InvalidProtocolBufferException e) {
            log.error("isTarget: ", e);
            return false;
        }
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.TencentVideo;
    }
}
