package com.bxm.pangu.rta.common.autoconfigure;

import com.bxm.pangu.rta.common.CachingRedisProperties;
import com.bxm.pangu.rta.common.core.RequestComputeTimesEventListener;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.message.dingding.DingDingMessageSender;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;

/**
 * @author allen
 * @date 2022-02-22
 * @since 1.0
 */
public class EventAutoConfiguration {

    private final CachingRedisProperties properties;

    public EventAutoConfiguration(CachingRedisProperties properties) {
        this.properties = properties;
    }

    @Bean(name = "rtaMessageSender")
    public MessageSender rtaMessageSender() {
        return new DingDingMessageSender(properties.getDingTalkUrl());
    }

    @Bean
    public RequestComputeTimesEventListener requestComputeTimesEventListener(@Qualifier("cachingCounter") Counter counter,
                                                                             @Qualifier("rtaMessageSender") MessageSender rtaMessageSender) {
        return new RequestComputeTimesEventListener(counter, rtaMessageSender);
    }
}
