package com.bxm.pangu.rta.scheduler;

import com.bxm.warcar.utils.NamedThreadFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;

/**
 * @author allen
 * @date 2021-12-20
 * @since 1.0
 */
@EnableScheduling
@SpringBootApplication
@EnableConfigurationProperties(SchedulerProperties.class)
public class SchedulerApplication implements SchedulingConfigurer {

    public static void main(String[] args) {
        SpringApplication.run(SchedulerApplication.class, args);
    }

    @Override
    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler(taskExecutor());
    }

    @Bean
    public Executor taskExecutor() {
        return new ScheduledThreadPoolExecutor(100, new NamedThreadFactory("scheduled"));
    }
}
