package com.bxm.pangu.rta.scheduler;

import com.google.common.collect.Sets;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Set;

/**
 * @author allen
 * @date 2021-12-21
 * @since 1.0
 */
@Data
@ConfigurationProperties(prefix = "scheduler")
public class SchedulerProperties {

    private int onewayRequestLimit = 1000;

    private int getuiRequestLimit = 300;

    private int mangoRequestLimit = 500;

    private int tencentVideoRequestLimit = 500;

    private int taobaoRequestLimit = 300;

    private String idImeiFileUri = "https://bxm-dcs.oss-cn-hangzhou.aliyuncs.com/feature_crowd_package/%s/imei/%s.csv";

    private String idOaidFileUri = "https://bxm-dcs.oss-cn-hangzhou.aliyuncs.com/feature_crowd_package/%s/oaid/%s.csv";

    /**
     * 文件缓存目录，默认当前用户根目录。
     */
    private String fileCacheDir = System.getProperty("user.home");

    /**
     * 基础文件将按这个数字来切割成多个文件。
     */
    private int batchLines = 1000;

    /**
     * 启用的调度器，只有配置在这里的调度器才会生效。
     * 配置的是 Bean Name，忽略大小写。
     */
    private Set<String> enable = Sets.newHashSet();

    /**
     * 日志写入批次数量
     */
    private int writeLogBatchSize = 100000;
}
