package com.bxm.pangu.rta.scheduler.core;

import com.bxm.pangu.rta.common.RtaRequest;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

/**
 * @author allen
 * @date 2021-12-21
 * @since 1.0
 * @deprecated 内存消耗太大，建议使用：{@link com.bxm.pangu.rta.scheduler.core.AbstractFilesRtaQueryScheduler}
 */
@Deprecated
public abstract class AbstractUrlFetchingScheduler extends AbstractRtaQueryScheduler {

    private DeviceFetcher deviceFetcher;

    public AbstractUrlFetchingScheduler(int corePoolSize, Consumer<RtaRequest> changeRequest, String crowdPkgId, Integer expireTimeInHour) {
        super(corePoolSize, changeRequest, crowdPkgId, expireTimeInHour);
    }
    public AbstractUrlFetchingScheduler(int corePoolSize, Consumer<RtaRequest> changeRequest, String crowdPkgId) {
        super(corePoolSize, changeRequest, crowdPkgId, null);
    }

    @Autowired
    public void setDeviceFetcher(DeviceFetcher deviceFetcher) {
        this.deviceFetcher = deviceFetcher;
    }

    protected abstract List<FetchRequest> getFetchRequest();

    @Override
    protected Map<Type, List<String>> fetchDevices() {
        List<FetchRequest> fetchRequest = getFetchRequest();
        if (Objects.isNull(fetchRequest)) {
            return Maps.newHashMap();
        }
        return deviceFetcher.fetch(fetchRequest);
    }
}
