package com.bxm.pangu.rta.scheduler.core;

import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.utils.DownloadHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author allen
 * @date 2021-12-20
 * @since 1.0
 */
@Slf4j
@Configuration
public class FileDeviceFetcher implements DeviceFetcher {

    private final SchedulerProperties properties;

    public FileDeviceFetcher(SchedulerProperties properties) {
        this.properties = properties;
    }

    @Override
    public Map<Type, List<String>> fetch(List<FetchRequest> requests) {
        String fileCacheDir = properties.getFileCacheDir();
        Map<Type, List<String>> res = Maps.newLinkedHashMap();

        for (FetchRequest request : requests) {
            String url = request.getUrl();
            String readyUrl = getReadyFileUrl(url);

            DownloadHelper helper = new DownloadHelper(readyUrl, fileCacheDir);
            File file = helper.download();
            if (Objects.isNull(file)) {
                if (log.isInfoEnabled()) {
                    log.info("Unfinished of {}", url);
                }
                return res;
            }
        }

        for (FetchRequest request : requests) {
            String url = request.getUrl();
            DownloadHelper helper = new DownloadHelper(url, fileCacheDir);
            File file = helper.download();
            if (Objects.isNull(file)) {
                continue;
            }
            try {
                List<String> lines = FileUtils.readLines(file, Charset.defaultCharset());
                res.put(request.getType(), lines);
            } catch (IOException e) {
                log.error("readLines: ", e);
            }
        }
        return res;
    }

    public static String getReadyFileUrl(String url) {
        // 判断文件是否已经准备就绪
        UriComponents build = UriComponentsBuilder.fromUriString(url).build();
        List<String> pathSegments = build.getPathSegments();
        int lastIndex = pathSegments.size() - 1;
        String lastPath = pathSegments.get(lastIndex);
        String[] arr = lastPath.split("\\.");
        String newLastPath = arr[0] + "_get_ready" + "." + arr[1];
        List<String> nPath = Lists.newArrayList();
        for (int i = 0; i < pathSegments.size() - 1; i++) {
            nPath.add(pathSegments.get(i));
        }
        nPath.add(newLastPath);
        return UriComponentsBuilder.fromUriString(url).replacePath(StringUtils.join(nPath, "/")).build().toString();
    }
}
