package com.bxm.pangu.rta.scheduler.core.autoconfigure;

import com.bxm.pangu.rta.common.taobao.TaobaoRtaClient;
import com.bxm.pangu.rta.common.taobao.TaobaoRtaProperties;
import org.springframework.context.annotation.Bean;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

/**
 * @author allen
 * @date 2022-01-14
 * @since 1.0
 */
public class InternalRtaClientAutoConfiguration {

    @Bean
    public TaobaoRtaClient taobaoInternalRtaClient() {
        TaobaoRtaProperties properties = new TaobaoRtaProperties();
        properties.setAppKey("29501476");
        properties.setAppSecret("5c34886c9f2efabaf3f1c76d352e77ad");
        properties.setChannel("3342106326");
        properties.setAdvertisingSpaceId("495424");
        properties.setConnectTimeout(200);
        properties.setSocketTimeout(1000);
        setTargetHandler(properties);
        return new TaobaoRtaClient(properties);
    }

    @Bean
    public TaobaoRtaClient bxmInternalRtaClient() {
        TaobaoRtaProperties properties = new TaobaoRtaProperties();
        properties.setAppKey("29155280");
        properties.setAppSecret("9bfe42052536d52723fff94c8c76cf4a");
        properties.setChannel("2200803434155");
        properties.setAdvertisingSpaceId("447574");
        properties.setConnectTimeout(200);
        properties.setSocketTimeout(1000);
        setTargetHandler(properties);
        return new TaobaoRtaClient(properties);
    }

    private void setTargetHandler(TaobaoRtaProperties properties) {
        properties.setTargetHandler(new Function<Map<Object, Object>, Boolean>() {
            @Override
            public Boolean apply(Map<Object, Object> objectObjectMap) {
                Object taskIdList = objectObjectMap.get("taskIdList");
                if (Objects.isNull(taskIdList)) {
                    return false;
                }
                Set<String> list = (Set<String>) taskIdList;
                return (list.contains("2089633783")) || list.contains("1163346009");
            }
        });
    }
}
