package com.bxm.pangu.rta.scheduler.core.controller;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author allen
 * @date 2022-02-16
 * @since 1.0
 */
@RestController
@RequestMapping("/query")
public class QueryController implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    @PostMapping("/{beanName}")
    public ResponseEntity<Object> execute(@PathVariable("beanName") String beanName,
                                          @RequestBody RtaRequest request) {
        try {
            RtaClient bean = applicationContext.getBean(beanName, RtaClient.class);
            return ResponseEntity.ok(bean.isTarget(request));
        } catch (BeansException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
