package com.bxm.pangu.rta.scheduler.core.controller;

import com.bxm.pangu.rta.scheduler.core.RtaQueryScheduler;
import com.bxm.warcar.utils.NamedThreadFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @date 2021-12-21
 * @since 1.0
 */
@RestController
@RequestMapping("/scheduler")
public class SchedulerController implements ApplicationContextAware, DisposableBean {

    private ApplicationContext applicationContext;
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 10, 0, TimeUnit.MILLISECONDS,
            new LinkedBlockingQueue<>(), new NamedThreadFactory("manual"));

    @PostMapping("/{beanName}")
    public ResponseEntity<Object> execute(@PathVariable("beanName") String beanName) {
        try {
            RtaQueryScheduler bean = applicationContext.getBean(beanName, RtaQueryScheduler.class);
            executor.submit(bean::execute);
            return ResponseEntity.ok().build();
        } catch (BeansException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void destroy() {
        executor.shutdownNow();
    }
}
