package com.bxm.pangu.rta.scheduler.core.download;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author allen
 * @date 2022-01-17
 * @since 1.0
 */
@Slf4j
public class Splitter {

    private final File file;
    private final int lineSizeOneFile;
    private final boolean deleteFile;

    private final AtomicInteger index = new AtomicInteger(0);

    public Splitter(File file, int lineSizeOneFile, boolean deleteFile) {
        this.file = file;
        this.lineSizeOneFile = lineSizeOneFile;
        this.deleteFile = deleteFile;
    }

    public List<File> split() {
        List<File> files = Lists.newArrayList();
        File parentFile = file.getParentFile();
        List<String> lines = null;
        try {
            lines = FileUtils.readLines(file, StandardCharsets.UTF_8);
        } catch (IOException e) {
            log.error("readLines: ", e);
        }
        if (Objects.isNull(lines)) {
            return null;
        }
        List<String> target = Lists.newArrayListWithCapacity(lineSizeOneFile);
        for (int i = 0; i < lines.size(); i++) {
            if (i > 0 && (i % lineSizeOneFile == 0 || i == lines.size() - 1)) {
                try {
                    File file = new File(parentFile.getPath() + File.separator + index.incrementAndGet());
                    FileUtils.writeLines(file, target);
                    files.add(file);
                    target.clear();
                    log.info("write lines to file {}", file);
                } catch (IOException e) {
                    log.error("writeLines: ", e);
                }
            }
            target.add(lines.get(i));
        }
        if (deleteFile) {
            FileUtils.deleteQuietly(file);
        }
        return files;
    }
}
