package com.bxm.pangu.rta.scheduler.core.event;

import com.bxm.pangu.rta.scheduler.core.Type;

import java.util.EventObject;

/**
 * @author allen
 * @date 2021-12-20
 * @since 1.0
 */
public class QueryTargetEvent extends EventObject {

    private final Type type;
    /**
     * 设备ID
     */
    private final String id;
    /**
     * 人群包ID
     */
    private final String crowdPkgId;
    /**
     * 过期时间，秒
     */
    private final int expireTimeInSeconds;

    public QueryTargetEvent(Object source, Type type, String id, String crowdPkgId, int expireTimeInSeconds) {
        super(source);
        this.type = type;
        this.id = id;
        this.crowdPkgId = crowdPkgId;
        this.expireTimeInSeconds = expireTimeInSeconds;
    }

    public Type getType() {
        return type;
    }

    public String getId() {
        return id;
    }

    public String getCrowdPkgId() {
        return crowdPkgId;
    }

    public int getExpireTimeInSeconds() {
        return expireTimeInSeconds;
    }
}
