package com.bxm.pangu.rta.scheduler.core.listener;

import com.bxm.pangu.rta.scheduler.core.CacheKey;
import com.bxm.pangu.rta.scheduler.core.Type;
import com.bxm.pangu.rta.scheduler.core.event.QueryTargetEvent;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author allen
 * @date 2021-12-21
 * @since 1.0
 */
public class TargetWriterListener implements EventListener<QueryTargetEvent> {

    private final static int HOURS_48_IN_SEC = 48 * 60 * 60;
    private final Updater updater;

    public TargetWriterListener(Updater updater) {
        this.updater = updater;
    }

    @Override
    @Subscribe
    public void consume(QueryTargetEvent event) {
        Type type = event.getType();
        KeyGenerator key = CacheKey.getCrowdPackageKey(type, event.getId());

        String crowdPkgId = event.getCrowdPkgId();

        int expireTimeInSeconds = event.getExpireTimeInSeconds();

        String expireTime = LocalDateTime.now().plusSeconds(expireTimeInSeconds).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        updater.hupdate(key, crowdPkgId, expireTime, expireTimeInSeconds < HOURS_48_IN_SEC ? HOURS_48_IN_SEC : expireTimeInSeconds);
    }
}
