package com.bxm.pangu.rta.scheduler.core.micrometer;

import com.bxm.pangu.rta.scheduler.core.RtaQueryScheduler;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;

import java.util.Collection;

/**
 * @author allen
 * @date 2021-12-21
 * @since 1.0
 */
@Configuration
public class RtaQuerySchedulerMeter implements MeterBinder {

    private final Collection<RtaQueryScheduler> schedulers;

    public RtaQuerySchedulerMeter(Collection<RtaQueryScheduler> schedulers) {
        this.schedulers = schedulers;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        schedulers.forEach(e -> {
            String name = ClassUtils.getUserClass(e.getClass()).getSimpleName();
            Gauge.builder("rta.scheduler.queue", e::getQueueSize).tag("name", name).register(registry);
            Gauge.builder("rta.scheduler.active", e::getActiveCount).tag("name", name).register(registry);
            Gauge.builder("rta.scheduler.core", e::getCorePoolSize).tag("name", name).register(registry);
            Gauge.builder("rta.scheduler.countDown", e::getCountDown).tag("name", name).register(registry);
        });
    }
}
