package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.AbstractUrlFetchingScheduler;
import com.bxm.pangu.rta.scheduler.core.FetchRequest;
import com.bxm.pangu.rta.scheduler.core.Type;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * @author allen
 * @date 2022-01-13
 * @since 1.0
 * @deprecated 内存消耗太大，建议使用：{@link com.bxm.pangu.rta.scheduler.core.AbstractFilesRtaQueryScheduler}
 */
@Deprecated
public abstract class AbstractFetchingRtaQueryScheduler extends AbstractUrlFetchingScheduler {

    private SchedulerProperties properties;

    public AbstractFetchingRtaQueryScheduler(int corePoolSize, Consumer<RtaRequest> changeRequest, String crowdPkgId, Integer expireTimeInHour) {
        super(corePoolSize, changeRequest, crowdPkgId, expireTimeInHour);
    }
    public AbstractFetchingRtaQueryScheduler(int corePoolSize, Consumer<RtaRequest> changeRequest, String crowdPkgId) {
        super(corePoolSize, changeRequest, crowdPkgId);
    }

    @Autowired
    public void setProperties(SchedulerProperties properties) {
        this.properties = properties;
    }

    /**
     * 返回 OSS 路径的 ID
     * @return 示例：100193
     */
    protected abstract String getOssId();

    @Override
    protected List<FetchRequest> getFetchRequest() {
        String id = getOssId();
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd"));

        ArrayList<FetchRequest> list = Lists.newArrayList();
        list.add(FetchRequest.builder().type(Type.OAID).url(String.format(properties.getIdOaidFileUri(), id, date)).build());
        list.add(FetchRequest.builder().type(Type.IMEI).url(String.format(properties.getIdImeiFileUri(), id, date)).build());
        return list;
    }
}
