package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.scheduler.core.AbstractFilesRtaQueryScheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.function.Consumer;

/**
 * @author allen
 * @date 2022-01-13
 * @since 1.0
 */
public class Baichuan1RtaQueryScheduler extends AbstractFilesRtaQueryScheduler {

    private RtaClient rtaClient;

    public Baichuan1RtaQueryScheduler() {
        super(300, new Consumer<RtaRequest>() {
            @Override
            public void accept(RtaRequest request) {
                request.setParam("1400");
            }
        }, (map) -> "25", () -> 30 * 24 * 60 * 60);
    }

    @Autowired
    public void setRtaClient(@Qualifier("baichuanRtaClient") RtaClient rtaClient) {
        this.rtaClient = rtaClient;
    }

    @Override
    public String getOssId() {
        return "100249";
    }

    @Override
    protected RtaClient getRtaClient() {
        return rtaClient;
    }
}
