package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.AbstractFilesRtaQueryScheduler;
import com.bxm.warcar.utils.DateHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * @author allen
 * @date 2022-01-13
 * @since 1.0
 */
public class HipoBxmTaobaoRtaQueryScheduler extends AbstractFilesRtaQueryScheduler {

    private RtaClient rtaClient;

    public HipoBxmTaobaoRtaQueryScheduler(SchedulerProperties properties) {
        super(500, new Consumer<RtaRequest>() {
            @Override
            public void accept(RtaRequest request) {
            }
        }, new Function<Map<Object, Object>, String>() {
            @Override
            public String apply(Map<Object, Object> objectObjectMap) {
                Object taskIdList = objectObjectMap.get("taskIdList");
                if (Objects.isNull(taskIdList)) {
                    return null;
                }
                Set<String> list = (Set<String>) taskIdList;
                if (list.contains("2089633783")) {
                    return "28";
                } else if (list.contains("1163346009")) {
                    return "30";
                }
                return null;
            }
        }, new Supplier<Integer>() {
            @Override
            public Integer get() {
                return (int) DateHelper.getRemainSecondsOfDay(2) - 18 * 60 * 60;
            }
        });
    }

    @Autowired
    public void setRtaClient(@Qualifier("bxmInternalRtaClient") RtaClient rtaClient) {
        this.rtaClient = rtaClient;
    }

    @Override
    public String getOssId() {
        return "100193";
    }

    @Override
    protected RtaClient getRtaClient() {
        return rtaClient;
    }

    @Override
    protected int getSkip() {
        return 10000000;
    }

    @Override
    protected int getRequestTotalLimit() {
        return 1000000;
    }
}
