package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.scheduler.core.AbstractFilesRtaQueryScheduler;
import com.bxm.warcar.utils.DateHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * @author allen
 * @date 2022-01-20
 * @since 1.0
 */
public class HipoHhdhhRtaQueryScheduler extends AbstractFilesRtaQueryScheduler {

    private RtaClient rtaClient;

    public HipoHhdhhRtaQueryScheduler() {
        super(2000, new Consumer<RtaRequest>() {
            @Override
            public void accept(RtaRequest request) {
                request.setParam("1163346009");
            }
        }, (map) -> "30", new Supplier<Integer>() {
            @Override
            public Integer get() {
                return (int) DateHelper.getRemainSecondsOfDay(2) - 18 * 60 * 60;
            }
        });
    }

    @Autowired
    public void setRtaClient(@Qualifier("hhdhhRtaClient") RtaClient rtaClient) {
        this.rtaClient = rtaClient;
    }

    @Override
    public String getOssId() {
        return "100193";
    }

    @Override
    protected RtaClient getRtaClient() {
        return rtaClient;
    }
}
