package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.scheduler.core.AbstractFilesRtaQueryScheduler;
import com.bxm.warcar.utils.DateHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * @author allen
 * @date 2022-01-24
 * @since 1.0
 */
@Slf4j
@Configuration
public class Kge519RtaQueryScheduler extends AbstractFilesRtaQueryScheduler {

    private RtaClient rtaClient;

    public Kge519RtaQueryScheduler() {
        super(250, new Consumer<RtaRequest>() {
            @Override
            public void accept(RtaRequest request) {
                request.setParam("329658014d2746a8996d8866455b4ff8|b7fd5afdf43643bdbdc2610351a2a7c8|517");
            }
        }, (map) -> "44", new Supplier<Integer>() {
            @Override
            public Integer get() {
                return (int) DateHelper.getRemainSecondsOfDay(1) + 9 * 60 * 60 + RandomUtils.nextInt(0, 600);
            }
        });
    }

    @Autowired
    public void setRtaClient(@Qualifier("kgeRtaClient") RtaClient rtaClient) {
        this.rtaClient = rtaClient;
    }

    @Override
    public String getOssId() {
        return "100225";
    }

    @Override
    protected RtaClient getRtaClient() {
        return rtaClient;
    }
}
