package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.AbstractUrlFetchingScheduler;
import com.bxm.pangu.rta.scheduler.core.FetchRequest;
import com.bxm.pangu.rta.scheduler.core.Type;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * @author allen
 * @date 2021-12-20
 * @since 1.0
 */
public class MangoRtaQueryScheduler extends AbstractUrlFetchingScheduler {

    private final SchedulerProperties properties;
    private RtaClient rtaClient;

    public MangoRtaQueryScheduler(SchedulerProperties properties) {
        super(properties.getMangoRequestLimit(), new Consumer<RtaRequest>() {
            @Override
            public void accept(RtaRequest request) {
                request.setOs(RtaRequest.Os.ANDROID);
                request.setParam("9");
            }
        }, "21");
        this.properties = properties;
    }

    @Override
    protected List<FetchRequest> getFetchRequest() {
        // https://bxm-dcs.oss-cn-hangzhou.aliyuncs.com/feature_crowd_package/weibo/imei/2021_12_20.csv
        String id = "100189";
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd"));

        ArrayList<FetchRequest> list = Lists.newArrayList();
        list.add(FetchRequest.builder().type(Type.OAID).url(String.format(properties.getIdOaidFileUri(), id, date)).build());
        list.add(FetchRequest.builder().type(Type.IMEI).url(String.format(properties.getIdImeiFileUri(), id, date)).build());
        return list;
    }

    @Autowired
    public void setRtaClient(@Qualifier("mangoRtaClient") RtaClient rtaClient) {
        this.rtaClient = rtaClient;
    }

    @Override
    protected RtaClient getRtaClient() {
        return rtaClient;
    }
}
