package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.scheduler.core.AbstractFilesRtaQueryScheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.function.Consumer;

/**
 * @author allen
 * @date 2022-01-10
 * @since 1.0
 */
public class MeituanRtaQueryScheduler extends AbstractFilesRtaQueryScheduler {

    private RtaClient rtaClient;

    public MeituanRtaQueryScheduler() {
        super(500, new Consumer<RtaRequest>() {
            @Override
            public void accept(RtaRequest request) {
                request.setParam("142884|10112901");
            }
        }, (map) -> "20");
    }

    @Autowired
    public void setRtaClient(@Qualifier("meituanRtaClient") RtaClient rtaClient) {
        this.rtaClient = rtaClient;
    }

    @Override
    protected RtaClient getRtaClient() {
        return rtaClient;
    }

    @Override
    public String getOssId() {
        return "100209";
    }
}
