package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.scheduler.core.AbstractFilesRtaQueryScheduler;
import com.bxm.warcar.utils.DateHelper;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * @author allen
 * @date 2022-01-13
 * @since 1.0
 */
public class Taobao1RtaQueryScheduler extends AbstractFilesRtaQueryScheduler {

    private final RtaClient rtaClient;

    public Taobao1RtaQueryScheduler(@Qualifier("taobao1RtaClient") RtaClient rtaClient) {
        super(600, null, new Function<Map<Object, Object>, String>() {
            @Override
            public String apply(Map<Object, Object> objectObjectMap) {
                Object taskIdList = objectObjectMap.get("taskIdList");
                if (Objects.isNull(taskIdList)) {
                    return null;
                }
                Set<String> list = (Set<String>) taskIdList;
                if (list.contains("1163346009")) {
                    return "30";
                } else if (list.contains("2089633783")) {
                    return "28";
                } else if (list.contains("1981891941")) {
                    return "32";
                } else if (list.contains("1763656536")) {
                    return "33";
                } else if (list.contains("32896")) {
                    return "34";
                }
                return null;
            }
        }, new Supplier<Integer>() {
            @Override
            public Integer get() {
                return (int) DateHelper.getRemainSecondsOfDay(2) - 18 * 60 * 60;
            }
        });
        this.rtaClient = rtaClient;
    }

    @Override
    public String getOssId() {
        return "100193";
    }

    @Override
    protected RtaClient getRtaClient() {
        return rtaClient;
    }

    @Override
    protected int getRequestTotalLimit() {
        return 80000000;
    }
}
