package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.AbstractUrlFetchingScheduler;
import com.bxm.pangu.rta.scheduler.core.FetchRequest;
import com.bxm.pangu.rta.scheduler.core.Type;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * @author allen
 * @date 2021-12-31
 * @since 1.0
 */
public class TencentVideoRtaQueryScheduler extends AbstractUrlFetchingScheduler {

    private final SchedulerProperties properties;
    private RtaClient rtaClient;

    public TencentVideoRtaQueryScheduler(SchedulerProperties properties) {
        super(properties.getTencentVideoRequestLimit(), new Consumer<RtaRequest>() {
            @Override
            public void accept(RtaRequest request) {
                request.setParam("xunfei");
            }
        }, "22");
        this.properties = properties;
    }

    @Autowired
    public void setRtaClient(@Qualifier("tencentVideoRtaClient") RtaClient rtaClient) {
        this.rtaClient = rtaClient;
    }

    @Override
    protected List<FetchRequest> getFetchRequest() {
        String id = "100207";
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd"));

        ArrayList<FetchRequest> list = Lists.newArrayList();
        list.add(FetchRequest.builder().type(Type.OAID).url(String.format(properties.getIdOaidFileUri(), id, date)).build());
        list.add(FetchRequest.builder().type(Type.IMEI).url(String.format(properties.getIdImeiFileUri(), id, date)).build());
        return list;
    }

    @Override
    protected RtaClient getRtaClient() {
        return rtaClient;
    }
}
