package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.scheduler.core.AbstractFilesRtaQueryScheduler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * @author allen
 * @date 2022-01-24
 * @since 1.0
 */
@Slf4j
public class TestRtaQueryScheduler extends AbstractFilesRtaQueryScheduler {

    private RtaClient rtaClient;

    public TestRtaQueryScheduler() {
        super(10, null, (map) -> "27");
    }

    @Autowired
    public void setRtaClient(@Qualifier("testingRtaClient") RtaClient rtaClient) {
        this.rtaClient = rtaClient;
    }

    @Override
    public String getOssId() {
        return "test";
    }

    @Override
    protected RtaClient getRtaClient() {
        return rtaClient;
    }

    @Override
    protected int getSkip() {
        return 0;
    }

    @Override
    protected int getRequestTotalLimit() {
        return 100;
    }
}
