package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.AbstractFilesRtaQueryScheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.function.Consumer;

/**
 * @author allen
 * @date 2022-01-10
 * @since 1.0
 */
public class Yhcs3RtaQueryScheduler extends AbstractFilesRtaQueryScheduler {

    private RtaClient rtaClient;

    public Yhcs3RtaQueryScheduler(SchedulerProperties properties) {
        super(500, new Consumer<RtaRequest>() {
            @Override
            public void accept(RtaRequest request) {
                request.setParam("xyymrta|6r72b7");
            }
        }, (map) -> "31");
    }

    @Autowired
    public void setRtaClient(@Qualifier("yhcsRtaClient") RtaClient rtaClient) {
        this.rtaClient = rtaClient;
    }

    @Override
    protected RtaClient getRtaClient() {
        return rtaClient;
    }

    @Override
    public String getOssId() {
        return "soyoungapp";
    }
}
