package com.bxm.pangu.rta.scheduler.core.utils;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * @author allen
 * @date 2021-12-21
 * @since 1.0
 */
public class FileHelper {

    private static final Logger LOGGER = LoggerFactory.getLogger(FileHelper.class);

    public static byte[] download(String url) {
        HttpURLConnection urlConnection = null;
        InputStream inputStream = null;
        ByteArrayOutputStream out = null;
        try {
            urlConnection = (HttpURLConnection) new URL(url).openConnection();
            int responseCode = urlConnection.getResponseCode();
            if (responseCode != 200) {
                return new byte[0];
            }
            inputStream = urlConnection.getInputStream();
            int length = urlConnection.getHeaderFieldInt("Content-Length", -1);
            int available = length > 0 ? length : inputStream.available();
            long start = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                BigDecimal mb = toMb(available);
                LOGGER.info("{} Starting download, The content length is {} MB...", url, mb);
            }

            float step = available / 100;

            out = new ByteArrayOutputStream(available);
            byte[] buffer = new byte[10 * 1024 * 1024];
            int len, i = 1;
            while ((len = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                int size = out.size();
                if (step >= 1 && size >= step * i) {
                    LOGGER.info("Downloading progress\t{}%\t{} MB", i++, toMb(size));
                }
            }
            out.flush();

            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{} Finished in {} ms!", url, (System.currentTimeMillis() - start));
            }

            return out.toByteArray();
        } catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("download: ", e);
            }
            return null;
        } finally {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(inputStream);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
        }
    }

    private static BigDecimal toMb(int size) {
        return new BigDecimal(size).divide(new BigDecimal(1024 * 1024), 2, RoundingMode.HALF_UP);
    }
}
