/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.FileRtaQueryScheduler;
import com.bxm.pangu.rta.scheduler.core.Type;
import com.bxm.pangu.rta.scheduler.core.download.OssControl;
import com.bxm.pangu.rta.scheduler.core.event.QueryLog;
import com.bxm.pangu.rta.scheduler.core.event.QueryLogEvent;
import com.bxm.pangu.rta.scheduler.core.event.QueryTargetEvent;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.ClassUtils;

@Configuration
public abstract class AbstractFilesRtaQueryScheduler
implements FileRtaQueryScheduler,
DisposableBean,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(AbstractFilesRtaQueryScheduler.class);
    private static final int DEFAULT_EXPIRE_TIME_IN_HOUR = 48;
    private static final int DEFAULT_EXPIRE_TIME_IN_SECONDS = 172800;
    private final RateLimiter limiter;
    private final ThreadPoolExecutor executor;
    private final Consumer<RtaRequest> changeRequest;
    private final Function<Map<Object, Object>, String> crowdPkgIdFetcher;
    private final Supplier<Integer> expireTimeFetcher;
    private SchedulerProperties properties;
    private EventPark eventPark;
    private OssControl ossControl;
    private AtomicInteger countDown = new AtomicInteger(0);
    private AtomicLong offset = new AtomicLong(0L);
    private final ScheduledThreadPoolExecutor offsetSync = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("offset-sync"));

    public AbstractFilesRtaQueryScheduler(int corePoolSize, Consumer<RtaRequest> changeRequest, Function<Map<Object, Object>, String> crowdPkgIdFetcher) {
        this(corePoolSize, changeRequest, crowdPkgIdFetcher, null);
    }

    public AbstractFilesRtaQueryScheduler(int corePoolSize, Consumer<RtaRequest> changeRequest, Function<Map<Object, Object>, String> crowdPkgIdFetcher, Supplier<Integer> expireTimeFetcher) {
        this.changeRequest = changeRequest;
        this.limiter = RateLimiter.create((double)corePoolSize);
        this.crowdPkgIdFetcher = crowdPkgIdFetcher;
        this.expireTimeFetcher = Optional.ofNullable(expireTimeFetcher).orElseGet(() -> () -> 172800);
        this.executor = new ThreadPoolExecutor(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("rta-query"));
    }

    @Autowired
    public void setProperties(SchedulerProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setEventPark(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    @Autowired
    public void setOssControl(OssControl ossControl) {
        this.ossControl = ossControl;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.offset = new AtomicLong(this.readOffset());
        this.offsetSync.scheduleWithFixedDelay(this::writeOffset, 0L, 1L, TimeUnit.MINUTES);
    }

    protected abstract RtaClient getRtaClient();

    protected int getSkip() {
        return 0;
    }

    protected int getRequestTotalLimit() {
        return Integer.MAX_VALUE;
    }

    @Scheduled(cron="0 0 0 * * ?")
    public void resetOffset() {
        this.offset = new AtomicLong(0L);
        this.writeOffset();
        log.info("{} reset offset.", (Object)this.getSimpleName());
    }

    @Override
    @Scheduled(cron="0 0 1 * * ?")
    public synchronized void execute() {
        try {
            String simpleName = this.getSimpleName();
            if (this.properties.getEnable().contains(simpleName)) {
                this.execute0();
            }
        }
        catch (Exception e) {
            log.error("execute0: ", (Throwable)e);
        }
    }

    private void execute0() {
        Map<Type, List<File>> mapFile;
        String simpleName = this.getSimpleName();
        log.info("Scheduler {} starting...", (Object)simpleName);
        boolean nonNull = Objects.nonNull(this.changeRequest);
        RtaClient rtaClient = this.getRtaClient();
        String ossId = this.getOssId();
        if (StringUtils.isBlank((String)ossId)) {
            log.warn("{} ossId must not blank!", (Object)simpleName);
            return;
        }
        while (!MapUtils.isNotEmpty(mapFile = this.ossControl.getMapFile(ossId))) {
            try {
                TimeUnit.MINUTES.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (LocalTime.now().getHour() < 23) continue;
        }
        this.offset = new AtomicLong(this.readOffset());
        int total = this.computeValueSize(mapFile);
        this.countDown = new AtomicInteger(total);
        if (this.countDown.get() == 0) {
            return;
        }
        LocalDate start = LocalDate.now();
        int skip = this.getSkip();
        log.info("{} Skip to {}", (Object)simpleName, (Object)skip);
        int requestTotalLimit = this.getRequestTotalLimit() + skip;
        if (requestTotalLimit <= 0) {
            requestTotalLimit = Integer.MAX_VALUE;
        }
        if (log.isInfoEnabled()) {
            log.info("{} - Total size {} has been ready at {}.", new Object[]{simpleName, this.countDown.get(), start});
        }
        AtomicLong index = new AtomicLong(0L);
        block3: for (Map.Entry<Type, List<File>> entry : mapFile.entrySet()) {
            Type type = entry.getKey();
            List<File> files = entry.getValue();
            for (File file : files) {
                List<String> values = this.readFile(file);
                if (log.isInfoEnabled()) {
                    log.info("{} Starting read {} file {} the size is {}", new Object[]{simpleName, type, file, values.size()});
                }
                for (String id : values) {
                    long i = index.incrementAndGet();
                    long offset = this.offset.get();
                    int times = total - this.countDown.decrementAndGet();
                    if ((long)skip >= i || i <= (long)skip + offset) continue;
                    this.limiter.acquire();
                    if (times > requestTotalLimit || LocalDate.now().isAfter(start)) {
                        this.countDown.set(0);
                        if (!log.isInfoEnabled()) break block3;
                        log.info("{} Scheduled abort!", (Object)simpleName);
                        break block3;
                    }
                    this.offset.incrementAndGet();
                    this.executor.submit(this.createNewTask(nonNull, rtaClient, type, id));
                }
            }
        }
        log.info("Scheduler {} was finished!", (Object)simpleName);
        System.gc();
    }

    private Runnable createNewTask(final boolean nonNull, final RtaClient rtaClient, final Type type, final String id) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    this.run0();
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }

            private void run0() {
                RtaRequest request = new RtaRequest();
                if (type == Type.IMEI) {
                    request.setImei_md5(id);
                } else if (type == Type.OAID) {
                    request.setOaid_md5(id);
                }
                if (nonNull) {
                    AbstractFilesRtaQueryScheduler.this.changeRequest.accept(request);
                }
                try {
                    boolean isTarget = rtaClient.isTarget(request, (Consumer)new Consumer<Map<Object, Object>>(){

                        @Override
                        public void accept(Map<Object, Object> objectObjectMap) {
                            String thisCrowdPkgId = (String)AbstractFilesRtaQueryScheduler.this.crowdPkgIdFetcher.apply(objectObjectMap);
                            int expireTime = (Integer)AbstractFilesRtaQueryScheduler.this.expireTimeFetcher.get();
                            if (StringUtils.isNotBlank((String)thisCrowdPkgId)) {
                                AbstractFilesRtaQueryScheduler.this.eventPark.post((EventObject)new QueryTargetEvent(this, type, id, thisCrowdPkgId, expireTime));
                                QueryLog queryLog = QueryLog.builder().taskId(AbstractFilesRtaQueryScheduler.this.getSimpleName()).type(type).id(id).crowdPkgId(thisCrowdPkgId).res(1).build();
                                AbstractFilesRtaQueryScheduler.this.eventPark.post((EventObject)new QueryLogEvent(this, queryLog));
                            } else {
                                log.warn("{} - No crowd package id.", (Object)AbstractFilesRtaQueryScheduler.this.getSimpleName());
                            }
                        }
                    });
                    if (!isTarget) {
                        QueryLog queryLog = QueryLog.builder().taskId(AbstractFilesRtaQueryScheduler.this.getSimpleName()).type(type).id(id).res(0).build();
                        AbstractFilesRtaQueryScheduler.this.eventPark.post((EventObject)new QueryLogEvent(this, queryLog));
                    }
                }
                catch (RtaRequestException e) {
                    QueryLog queryLog = QueryLog.builder().taskId(AbstractFilesRtaQueryScheduler.this.getSimpleName()).type(type).id(id).res(-1).exmsg(e.getMessage()).build();
                    AbstractFilesRtaQueryScheduler.this.eventPark.post((EventObject)new QueryLogEvent(this, queryLog));
                }
            }
        };
    }

    private List<String> readFile(File file) {
        try {
            return FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    private int computeValueSize(Map<Type, List<File>> map) {
        int totalSize = 0;
        Collection<List<File>> values = map.values();
        if (CollectionUtils.isEmpty(values)) {
            throw new NullPointerException("values");
        }
        for (List<File> list : values) {
            for (File file : list) {
                try {
                    totalSize += FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8).size();
                }
                catch (IOException e) {
                    log.error("readLines: ", (Throwable)e);
                }
            }
        }
        return totalSize;
    }

    private long readOffset() {
        File file = this.offsetFile();
        long offset = 0L;
        try {
            offset = NumberUtils.toLong((String)FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), (long)0L);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            log.error("readFileToString: ", (Throwable)e);
        }
        if (offset != 0L) {
            log.info("{} read offset {} on {}", new Object[]{this.getSimpleName(), offset, file});
        }
        return offset;
    }

    private void writeOffset() {
        try {
            File file = this.offsetFile();
            String l = TypeHelper.castToString((Object)this.offset.get());
            FileUtils.write((File)file, (CharSequence)l, (Charset)StandardCharsets.UTF_8);
            if (this.offset.get() != 0L) {
                log.info("{} write offset {} to {}", new Object[]{this.getSimpleName(), l, file});
            }
        }
        catch (Exception e) {
            log.error("write: ", (Throwable)e);
        }
    }

    private File offsetFile() {
        String simpleName = this.getSimpleName();
        return new File(this.properties.getFileCacheDir() + File.separator + ".rta" + File.separator + "offset_" + simpleName);
    }

    private String getSimpleName() {
        return ClassUtils.getShortName(this.getClass());
    }

    public void destroy() {
        this.executor.shutdownNow();
        this.writeOffset();
        this.offsetSync.shutdown();
    }

    @Override
    public int getCorePoolSize() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public int getQueueSize() {
        return this.executor.getQueue().size();
    }

    @Override
    public long getCountDown() {
        return this.countDown.get();
    }
}

