/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.scheduler.core.RtaQueryScheduler;
import com.bxm.pangu.rta.scheduler.core.Type;
import com.bxm.pangu.rta.scheduler.core.event.QueryTargetEvent;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.util.concurrent.RateLimiter;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

@Deprecated
public abstract class AbstractRtaQueryScheduler
implements RtaQueryScheduler,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractRtaQueryScheduler.class);
    private final RateLimiter limiter;
    private final ThreadPoolExecutor executor;
    private final Consumer<RtaRequest> changeRequest;
    private final String crowdPkgId;
    private final Integer expireTimeInHour;
    private EventPark eventPark;
    private AtomicInteger countDown = new AtomicInteger(0);

    public AbstractRtaQueryScheduler(int corePoolSize, Consumer<RtaRequest> changeRequest, String crowdPkgId, Integer expireTimeInHour) {
        this.changeRequest = changeRequest;
        this.crowdPkgId = crowdPkgId;
        this.limiter = RateLimiter.create((double)corePoolSize);
        this.expireTimeInHour = expireTimeInHour;
        this.executor = new ThreadPoolExecutor(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("P-" + crowdPkgId));
    }

    @Autowired
    public void setEventPark(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    protected abstract Map<Type, List<String>> fetchDevices();

    protected abstract RtaClient getRtaClient();

    protected int getRequestTotalLimit() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Scheduled(cron="0 0 1 * * ?")
    public synchronized void execute() {
        Map<Type, List<String>> map;
        log.info("Scheduler {} starting...", (Object)this.getClass().getSimpleName());
        boolean nonNull = Objects.nonNull(this.changeRequest);
        RtaClient rtaClient = this.getRtaClient();
        while (!MapUtils.isNotEmpty(map = this.fetchDevices())) {
            try {
                TimeUnit.MINUTES.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (LocalTime.now().getHour() < 23) continue;
        }
        int total = this.computeValueSize(map);
        this.countDown = new AtomicInteger(total);
        if (this.countDown.get() == 0) {
            return;
        }
        LocalDate start = LocalDate.now();
        int requestTotalLimit = this.getRequestTotalLimit();
        RtaType rtaType = rtaClient.getRtaType();
        if (log.isInfoEnabled()) {
            log.info("{} - {} size has been ready at {}.", new Object[]{rtaType, this.countDown.get(), start});
        }
        map.forEach((type, values) -> {
            if (log.isInfoEnabled()) {
                log.info("Starting {} the size is {}", (Object)type, (Object)values.size());
            }
            for (String id : values) {
                this.limiter.acquire();
                int times = total - this.countDown.get();
                if (times >= requestTotalLimit || LocalDate.now().isAfter(start)) {
                    this.countDown.set(0);
                    if (!log.isInfoEnabled()) break;
                    log.info("{} Scheduled abort!", (Object)rtaType);
                    break;
                }
                this.executor.submit(new Runnable((Type)((Object)type), id, nonNull, rtaClient){
                    final /* synthetic */ Type val$type;
                    final /* synthetic */ String val$id;
                    final /* synthetic */ boolean val$nonNull;
                    final /* synthetic */ RtaClient val$rtaClient;
                    {
                        this.val$type = type;
                        this.val$id = string;
                        this.val$nonNull = bl;
                        this.val$rtaClient = rtaClient;
                    }

                    @Override
                    public void run() {
                        try {
                            this.run0();
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                        }
                        finally {
                            AbstractRtaQueryScheduler.this.countDown.decrementAndGet();
                        }
                    }

                    private void run0() {
                        RtaRequest request = new RtaRequest();
                        if (this.val$type == Type.IMEI) {
                            request.setImei_md5(this.val$id);
                        } else if (this.val$type == Type.OAID) {
                            request.setOaid_md5(this.val$id);
                        }
                        if (this.val$nonNull) {
                            AbstractRtaQueryScheduler.this.changeRequest.accept(request);
                        }
                        try {
                            if (this.val$rtaClient.isTarget(request)) {
                                AbstractRtaQueryScheduler.this.eventPark.post((EventObject)new QueryTargetEvent(this, this.val$type, this.val$id, AbstractRtaQueryScheduler.this.crowdPkgId, 172800));
                            }
                        }
                        catch (RtaRequestException e) {
                            log.warn("isTarget: {}", (Object)e.getMessage());
                        }
                    }
                });
            }
        });
        log.info("{} was finished!", (Object)rtaType);
        map.clear();
        System.gc();
    }

    private int computeValueSize(Map<Type, List<String>> map) {
        int totalSize = 0;
        for (List<String> list : map.values()) {
            totalSize += list.size();
        }
        return totalSize;
    }

    public void destroy() {
        this.executor.shutdownNow();
    }

    @Override
    public int getCorePoolSize() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public int getQueueSize() {
        return this.executor.getQueue().size();
    }

    @Override
    public long getCountDown() {
        return this.countDown.get();
    }
}

