/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core;

import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.DeviceFetcher;
import com.bxm.pangu.rta.scheduler.core.FetchRequest;
import com.bxm.pangu.rta.scheduler.core.Type;
import com.bxm.pangu.rta.scheduler.core.utils.DownloadHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class FileDeviceFetcher
implements DeviceFetcher {
    private static final Logger log = LoggerFactory.getLogger(FileDeviceFetcher.class);
    private final SchedulerProperties properties;

    public FileDeviceFetcher(SchedulerProperties properties) {
        this.properties = properties;
    }

    @Override
    public Map<Type, List<String>> fetch(List<FetchRequest> requests) {
        String url;
        String fileCacheDir = this.properties.getFileCacheDir();
        LinkedHashMap res = Maps.newLinkedHashMap();
        for (FetchRequest request : requests) {
            url = request.getUrl();
            String readyUrl = FileDeviceFetcher.getReadyFileUrl(url);
            DownloadHelper helper = new DownloadHelper(readyUrl, fileCacheDir);
            File file = helper.download();
            if (!Objects.isNull(file)) continue;
            if (log.isInfoEnabled()) {
                log.info("Unfinished of {}", (Object)url);
            }
            return res;
        }
        for (FetchRequest request : requests) {
            url = request.getUrl();
            DownloadHelper helper = new DownloadHelper(url, fileCacheDir);
            File file = helper.download();
            if (Objects.isNull(file)) continue;
            try {
                List lines = FileUtils.readLines((File)file, (Charset)Charset.defaultCharset());
                res.put(request.getType(), lines);
            }
            catch (IOException e) {
                log.error("readLines: ", (Throwable)e);
            }
        }
        return res;
    }

    public static String getReadyFileUrl(String url) {
        UriComponents build = UriComponentsBuilder.fromUriString((String)url).build();
        List pathSegments = build.getPathSegments();
        int lastIndex = pathSegments.size() - 1;
        String lastPath = (String)pathSegments.get(lastIndex);
        String[] arr = lastPath.split("\\.");
        String newLastPath = arr[0] + "_get_ready." + arr[1];
        ArrayList nPath = Lists.newArrayList();
        for (int i = 0; i < pathSegments.size() - 1; ++i) {
            nPath.add(pathSegments.get(i));
        }
        nPath.add(newLastPath);
        return UriComponentsBuilder.fromUriString((String)url).replacePath(StringUtils.join((Collection)nPath, (String)"/")).build().toString();
    }
}

