/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core.controller;

import com.bxm.pangu.rta.scheduler.core.RtaQueryScheduler;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scheduler"})
public class SchedulerController
implements ApplicationContextAware,
DisposableBean {
    private ApplicationContext applicationContext;
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("manual"));

    @PostMapping(value={"/{beanName}"})
    public ResponseEntity<Object> execute(@PathVariable(value="beanName") String beanName) {
        try {
            RtaQueryScheduler bean = (RtaQueryScheduler)this.applicationContext.getBean(beanName, RtaQueryScheduler.class);
            this.executor.submit(bean::execute);
            return ResponseEntity.ok().build();
        }
        catch (BeansException e) {
            return ResponseEntity.notFound().build();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() {
        this.executor.shutdownNow();
    }
}

