/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core.download;

import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.FileRtaQueryScheduler;
import com.bxm.pangu.rta.scheduler.core.Type;
import com.bxm.pangu.rta.scheduler.core.download.OssDownload;
import com.bxm.pangu.rta.scheduler.core.download.Splitter;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.SafeMapHelper;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.ClassUtils;

@Configuration
public class OssControl
implements ApplicationListener<ApplicationStartedEvent>,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(OssControl.class);
    private final SchedulerProperties properties;
    private final Set<String> ossIds = Sets.newHashSet();
    private final ConcurrentHashMap<String, Map<Type, List<File>>> fileMap = new ConcurrentHashMap();
    private final ThreadPoolExecutor download = new ThreadPoolExecutor(20, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("dl"));

    public OssControl(SchedulerProperties properties) {
        this.properties = properties;
    }

    @Scheduled(cron="0 0 0 * * ?")
    public void clean() {
        this.clean0();
        this.download0();
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        Map beans = event.getApplicationContext().getBeansOfType(FileRtaQueryScheduler.class);
        beans.values().forEach(e -> {
            String ossId = e.getOssId();
            String shortName = ClassUtils.getShortName(e.getClass());
            if (this.properties.getEnable().contains(shortName)) {
                this.ossIds.add(ossId);
                log.info("Enabled {} for ossId: {}", (Object)shortName, (Object)ossId);
            }
        });
        this.clean0();
        this.download0();
    }

    public void destroy() throws Exception {
        this.clean0();
    }

    public Map<Type, List<File>> getMapFile(String ossId) {
        return this.fileMap.get(ossId);
    }

    private void clean0() {
        this.fileMap.values().forEach(new Consumer<Map<Type, List<File>>>(){

            @Override
            public void accept(Map<Type, List<File>> typeListMap) {
                typeListMap.values().forEach(new Consumer<List<File>>(){

                    @Override
                    public void accept(List<File> files) {
                        files.forEach(file -> {
                            FileUtils.deleteQuietly((File)file);
                            log.info("Deleted: {}", file);
                        });
                    }
                });
            }
        });
        this.fileMap.clear();
    }

    private void download0() {
        int batchLines = this.properties.getBatchLines();
        this.ossIds.forEach(id -> this.download.submit(new Runnable((String)id, batchLines){
            final /* synthetic */ String val$id;
            final /* synthetic */ int val$batchLines;
            {
                this.val$id = string;
                this.val$batchLines = n;
            }

            @Override
            public void run() {
                OssDownload download = new OssDownload(OssControl.this.properties, this.val$id);
                download.downloads();
                File oaidFile = download.getOaidFile();
                Splitter splitter = new Splitter(oaidFile, this.val$batchLines, false);
                List<File> oaidFiles = splitter.split();
                log.info("{} - oaid total files num is: {}", (Object)this.val$id, (Object)oaidFiles.size());
                File imeiFile = download.getImeiFile();
                Splitter imeiSplitter = new Splitter(imeiFile, this.val$batchLines, false);
                List<File> imeiFiles = imeiSplitter.split();
                log.info("{} - imei total files num is: {}", (Object)this.val$id, (Object)imeiFiles.size());
                ((Map)SafeMapHelper.get((Map)OssControl.this.fileMap, (Object)this.val$id, new LinkedHashMap())).put(Type.OAID, oaidFiles);
                ((Map)SafeMapHelper.get((Map)OssControl.this.fileMap, (Object)this.val$id, new LinkedHashMap())).put(Type.IMEI, imeiFiles);
            }
        }));
    }
}

