/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core.download;

import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.FileDeviceFetcher;
import com.bxm.pangu.rta.scheduler.core.utils.DownloadHelper;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssDownload {
    private static final Logger log = LoggerFactory.getLogger(OssDownload.class);
    private final SchedulerProperties properties;
    private final String ossId;
    private String oaidUri;
    private String imeiUri;
    private File oaidFile;
    private File imeiFile;

    public OssDownload(SchedulerProperties properties, String ossId) {
        this.properties = properties;
        this.ossId = ossId;
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd"));
        this.oaidUri = String.format(properties.getIdOaidFileUri(), ossId, date);
        this.imeiUri = String.format(properties.getIdImeiFileUri(), ossId, date);
    }

    public void downloads() {
        do {
            if (this.isReady()) {
                this.download();
                break;
            }
            log.info("{} not ready.", (Object)this.ossId);
            try {
                TimeUnit.MINUTES.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (LocalTime.now().getHour() < 23);
        log.info("{} Download finished!", (Object)this.ossId);
    }

    private boolean isReady() {
        String fileCacheDir = this.properties.getFileCacheDir();
        String oaidReadyFileUrl = FileDeviceFetcher.getReadyFileUrl(this.oaidUri);
        String imeiReadyFileUrl = FileDeviceFetcher.getReadyFileUrl(this.imeiUri);
        DownloadHelper oaidHelper = new DownloadHelper(oaidReadyFileUrl, fileCacheDir);
        File oaidFile = oaidHelper.download();
        if (Objects.isNull(oaidFile)) {
            return false;
        }
        FileUtils.deleteQuietly((File)oaidFile);
        DownloadHelper imeiHelper = new DownloadHelper(imeiReadyFileUrl, fileCacheDir);
        File imeiFile = imeiHelper.download();
        if (Objects.isNull(imeiFile)) {
            return false;
        }
        FileUtils.deleteQuietly((File)imeiFile);
        return true;
    }

    private void download() {
        String fileCacheDir = this.properties.getFileCacheDir();
        DownloadHelper oaidDownloadHelper = new DownloadHelper(this.oaidUri, fileCacheDir);
        DownloadHelper imeiDownloadHelper = new DownloadHelper(this.imeiUri, fileCacheDir);
        this.oaidFile = oaidDownloadHelper.download();
        this.imeiFile = imeiDownloadHelper.download();
    }

    public String getOaidUri() {
        return this.oaidUri;
    }

    public String getImeiUri() {
        return this.imeiUri;
    }

    public File getOaidFile() {
        return this.oaidFile;
    }

    public File getImeiFile() {
        return this.imeiFile;
    }
}

