/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core.download;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Splitter {
    private static final Logger log = LoggerFactory.getLogger(Splitter.class);
    private final File file;
    private final int lineSizeOneFile;
    private final boolean deleteFile;
    private final AtomicInteger index = new AtomicInteger(0);

    public Splitter(File file, int lineSizeOneFile, boolean deleteFile) {
        this.file = file;
        this.lineSizeOneFile = lineSizeOneFile;
        this.deleteFile = deleteFile;
    }

    public List<File> split() {
        ArrayList files = Lists.newArrayList();
        File parentFile = this.file.getParentFile();
        List lines = null;
        try {
            lines = FileUtils.readLines((File)this.file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("readLines: ", (Throwable)e);
        }
        if (Objects.isNull(lines)) {
            return null;
        }
        ArrayList target = Lists.newArrayListWithCapacity((int)this.lineSizeOneFile);
        for (int i = 0; i < lines.size(); ++i) {
            if (i > 0 && (i % this.lineSizeOneFile == 0 || i == lines.size() - 1)) {
                try {
                    File file = new File(parentFile.getPath() + File.separator + this.index.incrementAndGet());
                    FileUtils.writeLines((File)file, (Collection)target);
                    files.add(file);
                    target.clear();
                    log.info("write lines to file {}", (Object)file);
                }
                catch (IOException e) {
                    log.error("writeLines: ", (Throwable)e);
                }
            }
            target.add(lines.get(i));
        }
        if (this.deleteFile) {
            FileUtils.deleteQuietly((File)this.file);
        }
        return files;
    }
}

