/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core.listener;

import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.event.QueryLog;
import com.bxm.pangu.rta.scheduler.core.event.QueryLogEvent;
import com.bxm.pangu.rta.scheduler.core.listener.file.LogFileUploader;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.batch.BatchBlockingQueue;
import com.bxm.warcar.utils.batch.BatchQueue;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Scheduled;

public class LogWriteToFileEventListener
implements EventListener<QueryLogEvent>,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(LogWriteToFileEventListener.class);
    private static final String R = RandomStringUtils.randomAlphanumeric((int)8);
    private final LogFileUploader uploader;
    private final BatchQueue<String> batchQueue;
    private final File dir;

    public LogWriteToFileEventListener(LogFileUploader uploader, SchedulerProperties properties) {
        this.uploader = uploader;
        this.dir = this.createDir(properties);
        final String primaryKey = LogWriteToFileEventListener.getPrimaryKey();
        this.batchQueue = new BatchBlockingQueue(properties.getWriteLogBatchSize(), (Consumer)new Consumer<List<String>>(){

            @Override
            public void accept(List<String> strings) {
                try {
                    String fileName = LogWriteToFileEventListener.this.getCurrentlyFile(0, primaryKey);
                    File file = new File(fileName);
                    if (!file.exists() && !file.createNewFile()) {
                        throw new IOException("Cannot create file: " + file);
                    }
                    FileUtils.writeLines((File)file, strings, (boolean)true);
                }
                catch (IOException e) {
                    log.error("writeLines: ", (Throwable)e);
                }
            }
        }, 60000);
    }

    @Scheduled(cron="0 10 0 * * ?")
    public void scheduleUpload() {
        this.uploadFile();
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.uploadFile();
    }

    private void uploadFile() {
        String primaryKey = LogWriteToFileEventListener.getPrimaryKey();
        String fileName = this.getCurrentlyFile(-1, primaryKey);
        File file = new File(fileName);
        if (!file.exists()) {
            log.info("{} does not exists.", (Object)file);
            return;
        }
        log.info("{} starting upload.", (Object)file);
        this.uploader.upload(file, true);
    }

    private String getCurrentlyFile(int plusDays, String primaryKey) {
        return this.dir + File.separator + this.now("yyyy_MM_dd", plusDays) + "_" + primaryKey + ".json";
    }

    private String now(String pattern) {
        return this.now(pattern, 0);
    }

    private String now(String pattern, int plusDays) {
        return LocalDate.now().plusDays(plusDays).format(DateTimeFormatter.ofPattern(pattern));
    }

    @Subscribe
    public void consume(QueryLogEvent event) {
        QueryLog queryLog = event.getQueryLog();
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("stdate", this.now("yyyy-MM-dd"));
        body.put("taskid", queryLog.getTaskId());
        body.put("idtype", (Object)queryLog.getType());
        body.put("id", queryLog.getId());
        body.put("res", queryLog.getRes());
        body.put("exmsg", queryLog.getExmsg());
        body.put("crowdPkgId", queryLog.getCrowdPkgId());
        this.batchQueue.add((Object)JsonHelper.convert(body));
    }

    private File createDir(SchedulerProperties properties) {
        String fileCacheDir = properties.getFileCacheDir() + File.separator + "logs";
        File file = new File(fileCacheDir);
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new RuntimeException("Cannot create dir: " + file);
            }
        } else if (file.isFile()) {
            throw new RuntimeException(file + " is file!");
        }
        return file;
    }

    private static String getPrimaryKey() {
        try {
            String address = Inet4Address.getLocalHost().getHostAddress();
            if (StringUtils.isBlank((String)address)) {
                return R;
            }
            return address.replaceAll("\\.", "_");
        }
        catch (UnknownHostException e) {
            return R;
        }
    }
}

