/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core.listener;

import com.bxm.pangu.rta.scheduler.core.CacheKey;
import com.bxm.pangu.rta.scheduler.core.Type;
import com.bxm.pangu.rta.scheduler.core.event.QueryTargetEvent;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class TargetWriterListener
implements EventListener<QueryTargetEvent> {
    private static final int HOURS_48_IN_SEC = 172800;
    private final Updater updater;

    public TargetWriterListener(Updater updater) {
        this.updater = updater;
    }

    @Subscribe
    public void consume(QueryTargetEvent event) {
        Type type = event.getType();
        KeyGenerator key = CacheKey.getCrowdPackageKey(type, event.getId());
        String crowdPkgId = event.getCrowdPkgId();
        int expireTimeInSeconds = event.getExpireTimeInSeconds();
        String expireTime = LocalDateTime.now().plusSeconds(expireTimeInSeconds).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.updater.hupdate(key, crowdPkgId, (Object)expireTime, expireTimeInSeconds < 172800 ? 172800 : expireTimeInSeconds);
    }
}

