/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core.micrometer;

import com.bxm.pangu.rta.scheduler.core.RtaQueryScheduler;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Collection;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;

@Configuration
public class RtaQuerySchedulerMeter
implements MeterBinder {
    private final Collection<RtaQueryScheduler> schedulers;

    public RtaQuerySchedulerMeter(Collection<RtaQueryScheduler> schedulers) {
        this.schedulers = schedulers;
    }

    public void bindTo(MeterRegistry registry) {
        this.schedulers.forEach(e -> {
            String name = ClassUtils.getUserClass(e.getClass()).getSimpleName();
            Gauge.builder((String)"rta.scheduler.queue", e::getQueueSize).tag("name", name).register(registry);
            Gauge.builder((String)"rta.scheduler.active", e::getActiveCount).tag("name", name).register(registry);
            Gauge.builder((String)"rta.scheduler.core", e::getCorePoolSize).tag("name", name).register(registry);
            Gauge.builder((String)"rta.scheduler.countDown", e::getCountDown).tag("name", name).register(registry);
        });
    }
}

