/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core.scheduler;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.scheduler.SchedulerProperties;
import com.bxm.pangu.rta.scheduler.core.AbstractUrlFetchingScheduler;
import com.bxm.pangu.rta.scheduler.core.FetchRequest;
import com.bxm.pangu.rta.scheduler.core.Type;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class MangoRtaQueryScheduler
extends AbstractUrlFetchingScheduler {
    private final SchedulerProperties properties;
    private RtaClient rtaClient;

    public MangoRtaQueryScheduler(SchedulerProperties properties) {
        super(properties.getMangoRequestLimit(), new Consumer<RtaRequest>(){

            @Override
            public void accept(RtaRequest request) {
                request.setOs("android");
                request.setParam("9");
            }
        }, "21");
        this.properties = properties;
    }

    @Override
    protected List<FetchRequest> getFetchRequest() {
        String id = "100189";
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd"));
        ArrayList list = Lists.newArrayList();
        list.add(FetchRequest.builder().type(Type.OAID).url(String.format(this.properties.getIdOaidFileUri(), id, date)).build());
        list.add(FetchRequest.builder().type(Type.IMEI).url(String.format(this.properties.getIdImeiFileUri(), id, date)).build());
        return list;
    }

    @Autowired
    public void setRtaClient(@Qualifier(value="mangoRtaClient") RtaClient rtaClient) {
        this.rtaClient = rtaClient;
    }

    @Override
    protected RtaClient getRtaClient() {
        return this.rtaClient;
    }
}

